//Sensor schematics
//Potentiometer:
//        [+5v]
//          |
//          |
//          >
//          < ------------[Potentiometer]
//          >            |
//          <            |
//          |            |
//          |            |
//      [Ground]   [Analog Pin 0]
//
//
//
//
//Thermistor: 
//[Ground] ---- [10k-Resistor] -------|------- [Thermistor] ---- [+5v]
//                                    |
//                               [Analog Pin 1]

//Libraries
#include <SD.h>
#include <SPI.h>
#include <Wire.h>
#include <math.h>
#include "RTClib.h"

//RTC object creation
RTC_DS1307 RTC;

//Constants
const int Pot = A0;
const int Led = 13;
const int chipSelect = 10;

//Variables
int Pot_val = 0;
int Displacement = 0;
double Thermistor(int RawADC) {
  double Temp;
  Temp = log(10000.0*((1024.0/RawADC-1))); 
  Temp = 1 / (0.00116599982 + (0.00023302856 + (0.00000005342 * Temp * Temp ))* Temp );
  Temp = Temp - 273.15;            //From Kelvin to Celcius
  return Temp;
}

void setup() {
  pinMode(Pot, INPUT);
  pinMode(Led, OUTPUT); 
  Serial.begin(9600);
  while (!Serial) ;
  
  Serial.print("Initializing SD card...");
    if (!SD.begin(chipSelect)) {
    Serial.println("Card failed, or not present.");
    return;
    }
  Serial.println("card initialized.");

  Wire.begin();
  RTC.begin();
  if (! RTC.isrunning()) {
    Serial.println("RTC is NOT running!");
    RTC.adjust(DateTime(__DATE__, __TIME__));
  }
  Serial.println("RTC running... time adjusted.");
}

void loop() {
  DateTime now = RTC.now();
  Pot_val = analogRead(Pot); 
  Displacement = map(Pot_val, 0, 1023, 0, 1023);
  Serial.print(now.day());
    Serial.print("/");
    Serial.print(now.month());
    Serial.print("/");
    Serial.print(now.year());
    Serial.print(" ");
    Serial.print(now.hour(), DEC);
    Serial.print(":");
    Serial.print(now.minute(), DEC);
    Serial.print(":");
    Serial.print(now.second(), DEC);
    Serial.print("; ");
    Serial.print(float(Thermistor(analogRead(1))), 1);
    Serial.print("; ");
    Serial.print(Displacement);
    Serial.println(";");

  digitalWrite(Led, HIGH);
  delay(20);
  digitalWrite(Led, LOW);
  delay(29980);
  
  File dataFile = SD.open("datalog.txt", FILE_WRITE);
  if (dataFile) {
    dataFile.print(now.day());
    dataFile.print("/");
    dataFile.print(now.month());
    dataFile.print("/");
    dataFile.print(now.year());
    dataFile.print(" ");
    dataFile.print(now.hour(), DEC);
    dataFile.print(":");
    dataFile.print(now.minute(), DEC);
    dataFile.print(":");
    dataFile.print(now.second(), DEC);
    dataFile.print("; ");
    dataFile.print(float(Thermistor(analogRead(1))), 1);
    dataFile.print("; ");
    dataFile.print(Displacement);
    dataFile.println(";");
    dataFile.close();
  }
}
